/* commands.h -- functions to get commands and control r8c
 * Copyright (C) 2008  theDark
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _COMMANDS_H
#define _COMMANDS_H

int splitstr(const char *in, char *key, unsigned int keylen,
	     char *command, unsigned int commandlen);
int make_stepper_command(int *xpos, int *ypos, const char *in,
			 char *out, unsigned int len);
int is_analog(const char *in);
int r8c_sr(FILE *r, FILE *w, const char *sendstr, char *recvstr, unsigned int len);

void make_c_error(const char *fname, int error);
int c_start(int x, int y, int sock, FILE *r, FILE *w);
int c_xy(int x, int y, int sock, FILE *r, FILE *w, const char *command);
int c_scan(int x, int y, int sock, FILE *r, FILE *w, const char *command);
int c_line(int x, int y, int sock, FILE *r, FILE *w, const char *command);


#endif /* _COMMANDS_H */
