/* definitions.h -- Basic definitions; maybe you want to change some of them
 * Copyright (C) 2008  theDark
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _DEFINITIONS_H
#define _DEFINITIONS_H


/* maybe you want to change the some of the following definitions */
#define SERIAL "/dev/ttyUSB0"	// device the r8c is connected to
#define BAUDRATE B9600		// baudrate for serial connection (has to be valid constant)
#define XPOS_MAX 3000		// maximum x position in cycles
#define YPOS_MAX 3000		// maximum y position in cycles

#define USE_PLOT_FUNCTIONS 1	// if you want to use scan and line (you need "gnuplot")
#define PLOT_XINT 100		// in scan and line every XINT cycles a value is saved
#define PLOT_YINT 100		// in scan and line every YINT cycles a value is saved
#define PLOT_DATFILE "/var/www/dat/plot.dat" // values are saved in this file
#define PLOT_PICFILE "/var/www/dat/plot.png" // file of the picture (graph) generated with gnuplot

#define PORT 7999		// port to listen on
#define USE_TIME 3600		// how long shall one user control the rcl (in seconds)
#define MAX_RETRIES 3		// if r8c doesn't return OK we retry sending MAX_RETRIES times
#define MAX_CLIENTS 5		// how many clients may connect simultaneously
				// probably doesn't have an effect (depends on kernel settings)
#define DAEMON 1		// run as daemon or not (foreground)
#define ERRORFILE "rcld.err"	// only used in daemon mode
#define LOGFILE "rcld.log"	// only used in daemon mode
#define DEBUG 1			// debug level [0-2]



/* normally you don't need to change anything of the following stuff */
#define SUN_PATH1 "\0/rcld/main1"
#define SUN_PATH1_LENGTH 13	   // with trailing '\0'
#define SUN_PATH2 "\0/rcld/main2"
#define SUN_PATH2_LENGTH 13	   // with trailing '\0'
#define SUN_PATH3 "\0/rcld/cxa"
#define SUN_PATH3_LENGTH 11	   // with trailing '\0'
#define SUN_TMP_PATH "#/rcld/tmp-" // followed by pid;
				   // don't delete # which will be replaced with '\0'
#define BUF 1024


#endif /* _DEFINITIONS_H */
