<?php

/* rcl_hp -- Homepage to control daemon and watch webcam
 * Copyright (C) 2008  theDark
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

echo "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
	<?php
	include "config.inc";	/* include config file */

	echo "<title>".$_title."</title>\n";
	foreach($_meta as $name => $content) {
		echo "\t<meta name=\"".$name."\" content=\"".$content."\" />\n";
	}
	echo "\t<meta http-equiv=\"refresh\" content=\"".$_site_refresh."; URL=http://";
	echo $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'].$_SERVER['PHP_SELF']."\" />\n";
	?>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<link rel="stylesheet" type="text/css" href="format.css" />
	<?php
	if($_favicon > 0) {
		echo "\t<link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"favicon.ico\" />\n";
	}
	?>

	<script type="text/javascript">
	/* <![CDATA[ */
		function webcam_reload() {
			var now = new Date();
<?php
echo "\t\t\tdocument.images.webcam.src = \"http://".$_SERVER['SERVER_NAME'].":".$_webcam_port."/?\" + now.getTime();\n";
echo "\t\t\tsetTimeout(\"webcam_reload()\", ".$_webcam_reload.");\n";
echo "\t\t}\n";
echo "\t\tsetTimeout(\"webcam_reload()\", ".$_webcam_reload.");\n";
?>
	/* ]]> */
	</script>
	
</head>

<body>
<?php

$sock = @fsockopen('localhost', $_daemon_port, $sock_errno, $sock_error, 10);
if(!$sock) {
	echo "<p class=\"error\">\n";
	echo "  FATAL: Could not connect to daemon: ".$sock_error."\n";
	echo "</p>\n\n";
	echo "</body>\n";
	echo "</html>\n";
	die();
}


if(!isset($_GET['action']))
	$_GET['action'] = "";

if($_GET['action'] == "logout" OR $_GET['action'] == "start" OR $_GET['action'] == "cancel") {
	fwrite($sock, $_SERVER['REMOTE_ADDR']." ".$_GET['action']."\n");
	$buffer = fread($sock, 1024);
	if($buffer != "OK\n")
		$error = "Daemon returned: ".$buffer;
}
elseif($_GET['action'] == "login") {
	if(!isset($_POST['code']) OR $_POST['code'] != $_code)
		$error = "Wrong login code\n";
	else {
		fwrite($sock, $_SERVER['REMOTE_ADDR']." ".$_GET['action']."\n");
		$buffer = fread($sock, 1024);
		if($buffer != "OK\n")
			$error = "Daemon returned: ".$buffer;
	}
}
elseif($_GET['action'] == "x" OR $_GET['action'] == "y") {
	if(isset($_GET['what']) AND isset($_GET['value'])) {
		$what = $_GET['what'];
		$value = $_GET['value'];
	}
	elseif(isset($_POST['what']) AND isset($_POST['value'])) {
		$what = $_POST['what'];
		$value = $_POST['value'];
	}
	else
		$error = "Missing argument\n";

	if(!isset($error)) {
		fwrite($sock, $_SERVER['REMOTE_ADDR']." ".$_GET['action'].$what.$value."\n");
		$buffer = fread($sock, 1024);
		if($buffer != "OK\n")
			$error = "Daemon returned: ".$buffer;
	}
}
elseif($_GET['action'] == "scan") {
	if(!isset($_POST['x']) OR !isset($_POST['y']))
		$error = "Missing argument\n";
	
	else {
		fwrite($sock, $_SERVER['REMOTE_ADDR']." ".$_GET['action']." ".$_POST['x']." ".$_POST['y']."\n");
		$buffer = fread($sock, 1024);
		if($buffer != "OK\n")
			$error = "Daemon returned: ".$buffer;
	}
}
elseif($_GET['action'] == "line") {
	if(!isset($_POST['what']) OR !isset($_POST['value']))
		$error = "Missing argument\n";
		
	else {
		fwrite($sock, $_SERVER['REMOTE_ADDR']." ".$_GET['action']." ".$_POST['what']." ".$_POST['value']."\n");
		$buffer = fread($sock, 1024);
		if($buffer != "OK\n")
			$error = "Daemon returned: ".$buffer;
	}
}
elseif($_GET['action'] == "analog") {
   	fwrite($sock, $_SERVER['REMOTE_ADDR']." ".$_GET['action']."\n");
	$buffer = fread($sock, 1024);
	preg_match("/(.*)%\n/", $buffer, $match);
	if(!isset($match[1]) OR !is_numeric($match[1]))
		$error = "Daemon returned: ".$buffer;
	else {
		preg_match("/(.*)\n/", $buffer, $match);
		$analog = $match[1];
	}	
}


fwrite($sock, $_SERVER['REMOTE_ADDR']." getpos\n");
$buffer = fread($sock, 1024);
preg_match("/(.*) (.*)\n/", $buffer, $match);
$xpos = $match[1];
$ypos = $match[2];

fwrite($sock, $_SERVER['REMOTE_ADDR']." gettime\n");
$buffer = fread($sock, 1024);
preg_match("/(.*)\n/", $buffer, $match);
$time = $match[1];

fwrite($sock, $_SERVER['REMOTE_ADDR']." getusetime\n");
$buffer = fread($sock, 1024);
preg_match("/(.*)\n/", $buffer, $match);
$usetime = $match[1];

fwrite($sock, $_SERVER['REMOTE_ADDR']." getxposmax\n");
$buffer = fread($sock, 1024);
preg_match("/(.*)\n/", $buffer, $match);
$xposmax = $match[1];

fwrite($sock, $_SERVER['REMOTE_ADDR']." getyposmax\n");
$buffer = fread($sock, 1024);
preg_match("/(.*)\n/", $buffer, $match);
$yposmax = $match[1];

fwrite($sock, $_SERVER['REMOTE_ADDR']." getplotxint\n");
$buffer = fread($sock, 1024);
preg_match("/(.*)\n/", $buffer, $match);
$plotxint = $match[1];

fwrite($sock, $_SERVER['REMOTE_ADDR']." getplotyint\n");
$buffer = fread($sock, 1024);
preg_match("/(.*)\n/", $buffer, $match);
$plotyint = $match[1];

fwrite($sock, $_SERVER['REMOTE_ADDR']." loggedin\n");
$buffer = fread($sock, 1024);
preg_match("/(.*)\n/", $buffer, $match);
$loggedin = $match[1];


fclose($sock);

?>
	<div id="root">
	<div id="right">

<div>
	<br />
<?php

if($loggedin == "YES")
	echo "\tYou are logged in<br />\n";
elseif($loggedin == "NO")
	echo "\tNobody is logged in<br />\n";
else
	echo "\tSomebody is logged in<br />\n";

if($loggedin != "NO" AND $time >= 0)
	echo "\tTime: ".round((float)$time/60, 2)."min/".round((float)$usetime/60, 2)."min remaining<br />\n";
elseif($loggedin != "NO" AND $time < 0)
	echo "\tTime: Time is up since ".round((float)(0-$time)/60, 2)."min<br />\n";

echo "\t<br />\n";

if($loggedin == "YES")
	echo "\t<a href=\"?action=logout\">Logout</a><br />\n";
else {
	echo "\t\t<form action=\"?action=login\" method=\"post\" class=\"form\">\n";
	echo "\t\t<ul>\n";
	echo "\t\t\t<li><img width=\"".$_codepicwidth."\" height=\"".$_codepicheight."\" ";
	echo "src=\"".$_codepic."\" alt=\"Code\" /></li>\n";
	echo "\t\t\t<li><input type=\"text\" name=\"code\" size=\"4\" /></li>\n";
	echo "\t\t\t<li><input type=\"submit\" name=\"submit\" value=\"Login\" /></li>\n";
	echo "\t\t</ul>\n";
	echo "\t\t</form>\n";
}

?>


	<hr />
	<a href="?action=start">Go to start</a><br />
	<form action="?action=scan" method="post" class="form">
	<ul>
		<li><select name="x" size="1">
<?php
		for($i = $xpos; $i <= $xposmax; $i+= $plotxint) 
			echo "\t\t\t<option value=\"".$i."\">".$i."</option>\n";
?>
		</select></li>
		<li><select name="y" size="1">
<?php
		for($i = $ypos; $i <= $yposmax; $i+= $plotyint) 
			echo "\t\t\t<option value=\"".$i."\">".$i."</option>\n";
?>
		</select></li>
		<li><input type="submit" name="submit" value="Scan" /></li>
	</ul>
	</form>
	<form action="?action=line" method="post" class="form">
	<ul>
		<li><select name="what" size="1">
			<option value="x">x</option>
			<option value="y">y</option>
		</select></li>
		<li><select name="value" size="1">
<?php
		for($i = $xpos; $i <= $xposmax; $i+= $plotxint) 
			echo "\t\t\t<option value=\"".$i."\">x: ".$i."</option>\n";

		for($i = $ypos; $i <= $yposmax; $i+= $plotyint) 
			echo "\t\t\t<option value=\"".$i."\">y: ".$i."</option>\n";
?>
		</select></li>
		<li><input type="submit" name="submit" value="Line" /></li>
	</ul>
	</form>
	<br />
	<a href="?action=cancel">Cancel (after start, scan or line)</a><br />
   	<br />
<?php
	echo "\t<a href=\"".$_plot_dat."?".time()."\">Get measured data (after scan or line)</a><br />\n";
	echo "\t<a href=\"".$_plot_pic."?".time()."\">Watch graph (after scan or line)</a><br />\n";
?>
	<br />
</div>


<p id="buttons"><a href="http://validator.w3.org/check?uri=referer">
<img class="href_img" src="images/valid_xhtml10.gif" alt="Valid XHTML 1.0 Strict!" height="15" width="80" />
</a>
<br />
<a href="http://jigsaw.w3.org/css-validator/check/referer?warning=0">
<img class="href_img" src="images/valid_css.gif" alt="Valid CSS!" height="15" width="80" />
</a>
<br />
<a href="http://www.debian.org">
<img class="href_img" src="images/debian.png" alt="Debian powered!" height="15" width="80" />
</a><br /></p>

	</div>


	<div id="content">

<?php
echo "<h1>".$_title."</h1>\n";

if(isset($error)) {
	echo "<p class=\"error\">\n";
	echo "  ERROR: ".$error;
	echo "</p>\n\n";
}

echo "<table border=\"0\" id=\"maintable\">\n";
echo "\t<tr>\n";
echo "\t\t<td></td><td>x: ".$xpos."/".$xposmax."</td>\n";
echo "\t\t<td rowspan=\"2\">\n";
echo "\t\t\t<a href=\"?action=y&amp;what=%2B&amp;value=800\" title=\"y+800\"><img src=\"images/up.png\" ";
echo "width=\"24\" height=\"24\" alt=\"A\" class=\"href_img\" /></a><br />\n";
echo "\t\t\t<a href=\"?action=y&amp;what=%2B&amp;value=400\" title=\"y+400\"><img src=\"images/up.png\" ";
echo "width=\"24\" height=\"24\" alt=\"A\" class=\"href_img\" /></a><br />\n";
echo "\t\t\t<a href=\"?action=y&amp;what=%2B&amp;value=200\" title=\"y+200\"><img src=\"images/up.png\" ";
echo "width=\"24\" height=\"24\" alt=\"A\" class=\"href_img\" /></a>\n";
echo "\t\t</td><td>";
if(isset($analog))
	echo $analog;

echo "</td><td></td>\n";
echo "\t</tr><tr>\n";
echo "\t\t<td></td><td>y: ".$ypos."/".$yposmax."</td>\n";
echo "\t\t<td><a href=\"?action=analog\">measure</a></td><td></td>\n";
echo "\t</tr><tr>\n";
echo "\t\t<td>\n";
echo "\t\t\t<a href=\"?action=x&amp;what=-&amp;value=800\" title=\"x-800\"><img src=\"images/left.png\" ";
echo "width=\"24\" height=\"24\" alt=\"&lt;\" class=\"href_img\" /></a>\n";
echo "\t\t\t<a href=\"?action=x&amp;what=-&amp;value=400\" title=\"x-400\"><img src=\"images/left.png\" ";
echo "width=\"24\" height=\"24\" alt=\"&lt;\" class=\"href_img\" /></a>\n";
echo "\t\t\t<a href=\"?action=x&amp;what=-&amp;value=200\" title=\"x-200\"><img src=\"images/left.png\" ";
echo "width=\"24\" height=\"24\" alt=\"&lt;\" class=\"href_img\" /></a>\n";
echo "\t\t</td><td colspan=\"3\">\n";
echo "\t\t\t<img id=\"webcam\" width=\"".$_webcam_width."\" height=\"".$_webcam_height."\" src=\"http://";
echo $_SERVER['SERVER_NAME'].":".$_webcam_port."/?".time()."\" alt=\"Could not connect to webcam\" />\n";
echo "\t\t</td><td>\n";
echo "\t\t\t<a href=\"?action=x&amp;what=%2B&amp;value=200\" title=\"x+200\"><img src=\"images/right.png\" ";
echo "width=\"24\" height=\"24\" alt=\"&gt;\" class=\"href_img\" /></a>\n";
echo "\t\t\t<a href=\"?action=x&amp;what=%2B&amp;value=400\" title=\"x+400\"><img src=\"images/right.png\" ";
echo "width=\"24\" height=\"24\" alt=\"&gt;\" class=\"href_img\" /></a>\n";
echo "\t\t\t<a href=\"?action=x&amp;what=%2B&amp;value=800\" title=\"x+800\"><img src=\"images/right.png\" ";
echo "width=\"24\" height=\"24\" alt=\"&gt;\" class=\"href_img\" /></a>\n";
echo "\t\t</td>\n";
echo "\t</tr><tr>\n";
echo "\t\t<td></td><td>\n";
echo "\t\t\t<form action=\"?action=x\" method=\"post\" class=\"form\">\n";
echo "\t\t\t<ul>\n";
echo "\t\t\t\t<li>x</li>\n";
echo "\t\t\t\t<li><select name=\"what\" size=\"1\">\n";
echo "\t\t\t\t\t<option value=\"=\">=</option>\n";
echo "\t\t\t\t\t<option value=\"+\">+</option>\n";
echo "\t\t\t\t\t<option value=\"-\">-</option>\n";
echo "\t\t\t\t</select></li>\n";
echo "\t\t\t\t<li><input type=\"text\" name=\"value\" value=\"0\" size=\"4\" /></li>\n";
echo "\t\t\t\t<li><input type=\"submit\" name=\"submit\" value=\"Set\" /></li>\n";
echo "\t\t\t</ul>\n";
echo "\t\t\t</form>\n";
echo "\t\t</td><td>\n";
echo "\t\t\t<a href=\"?action=y&amp;what=-&amp;value=200\" title=\"y-200\"><img src=\"images/down.png\" ";
echo "width=\"24\" height=\"24\" alt=\"V\" class=\"href_img\" /></a><br />\n";
echo "\t\t\t<a href=\"?action=y&amp;what=-&amp;value=400\" title=\"y-400\"><img src=\"images/down.png\" ";
echo "width=\"24\" height=\"24\" alt=\"V\" class=\"href_img\" /></a><br />\n";
echo "\t\t\t<a href=\"?action=y&amp;what=-&amp;value=800\" title=\"y-800\"><img src=\"images/down.png\" ";
echo "width=\"24\" height=\"24\" alt=\"V\" class=\"href_img\" /></a>\n";
echo "\t\t</td><td>\n";
echo "\t\t\t<form action=\"?action=y\" method=\"post\" class=\"form\">\n";
echo "\t\t\t<ul>\n";
echo "\t\t\t\t<li>y</li>\n";
echo "\t\t\t\t<li><select name=\"what\" size=\"1\">\n";
echo "\t\t\t\t\t<option value=\"=\">=</option>\n";
echo "\t\t\t\t\t<option value=\"+\">+</option>\n";
echo "\t\t\t\t\t<option value=\"-\">-</option>\n";
echo "\t\t\t\t</select></li>\n";
echo "\t\t\t\t<li><input type=\"text\" name=\"value\" value=\"0\" size=\"4\" /></li>\n";
echo "\t\t\t\t<li><input type=\"submit\" name=\"submit\" value=\"Set\" /></li>\n";
echo "\t\t\t</ul>\n";
echo "\t\t\t</form>\n";
echo "\t\t</td><td></td>\n";
echo "\t</tr>\n";
echo "</table>\n";
?>

	</div>
	<br class="clear" />

	</div>

</body>
</html>
