#include "display.h"
#include "generic.h"
#include "sfr_r813.h"

void lcddata(unsigned char c) {
	unsigned char data;
	
	data = c & 0xf0;		// higher 4 bits
	data += 0x04;			// RS = 1 (data)
	p0 = data;
	p0 = data + 0x08;		// E = 1
	asm("nop");
	p0 = data;			// E = 0 (impulse)
	data = ((c & 0x0f) << 4);	// lower 4 bits
	data += 0x04;			// RS = 1 (data)
	p0 = data;
	p0 = data + 0x08;		// E = 1
	asm("nop");
	p0 = data;			// E = 0 (impulse)
	wait(100);
}

void lcdctrl(unsigned char c) {
	unsigned char data;
	
	data = c & 0xf0;		// higher 4 bits
	p0 = data;
	p0 = data + 0x08;		// E = 1
	asm("nop");
	p0 = data;			// E = 0 (impulse)
	data = ((c & 0x0f) << 4);	// lower 4 bits
	p0 = data;
	p0 = data + 0x08;		// E = 1
	asm("nop");
	p0 = data;			// E = 0 (impulse)
	wait(100);
}

void lcdpos(unsigned int line, unsigned int row) {
	if(line > 2)
		line = 2;
	if(row > 40)
		row = 40;
	
	lcdctrl(0x80 + row-1 + (0x40 * (line-1)));
	wait(100);
}

void initlcd() {
	prc2 = 1;	// disable protection
	pd0 |= 0xfc;	// set output ports

	wait(10000);
	lcdctrl(0x28);	// function set: 4 bit; dual line; 5x8 font
	wait(5000);
	lcdctrl(0x28);
	wait(1000);
	lcdctrl(0x28);
	wait(1000);
	lcdctrl(0x0c);	// display ON
	wait(1000);
	lcdctrl(0x01);	// display clear
	wait(5000);
}

void writelcd(const char *buffer) {
	int i;

	for(i = 0; buffer[i] != '\0'; i++)
		lcddata(buffer[i]);
}
