/* generic.c -- Some really generic functions which are often needed
 * Copyright (C) 2008  theDark
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "generic.h"
#include "sfr_r813.h"


void initblink() {
	int i;

	pd1 |= 0x0f;
	for(i = 0; i < 4; i++) {
		p1_0 = 1;
		p1_3 = 0;
		pause();
		p1_1 = 1;
		p1_0 = 0;
		pause();
		p1_2 = 1;
		p1_1 = 0;
		pause();
		p1_3 = 1;
		p1_2 = 0;
		pause();
	}
	p1_3 = 0;
}

void pause() {
	int i, j;

	for(i = 0; i < 1000; i++) {
		for(j = 0; j < 100; j++);
		wdtr = 0x00;
	}
}

void wait(unsigned int time) {
	int i;
	
	if(time > 20000)
		time = 20000;

	for(i = 0; i < time; i++);

	wdtr = 0x00;
}

void splitstr(const char *in, char *out, unsigned int len, unsigned int n) {
	int i, j = 0;
	int start, end = 0;
	int quotecnt = 0;

	for(i = 0; i < n; i++) {
		for(; in[j] != '\n' && in[j] != '\0'; j++) {
			if(in[j] == '\"')
				quotecnt++;
			else if(in[j] == ' ' && (quotecnt % 2) == 0)
				break;
		}

		start = end;
		end = j+1;

		if(in[j] == '\0')
			break; 

		j++;
	}

	if(in[start] == '\"' && in[end-2] == '\"') {
		start++;
		end--;
	}

	if(end - start > len)
		end = start + len;
	
	for(i = start, j = 0; i < end-1; i++, j++)
		out[j] = in[i];
	
	out[j] = '\0';
}

int eq(const char *str1, const char *str2) {
	int i;

	for(i = 0; str1[i] != '\0' && str2[i] != '\0'; i++) {
		if(str1[i] != str2[i])
			return 0;
	}

	if(str1[i] == str2[i])
		return 1;
	
	return 0;
}

