/* inthandlers.h -- Interrupt handlers
 * Copyright (C) 2008  theDark
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _INTHANDLERS_H
#define _INTHANDLERS_H

#define INT_ENTRY_PLAIN __asm__("pushm\tr0,r1,r2,r3,a0,a1,sb,fb")
#define INT_ENTRY_STACK __asm__("pushm\tr0,r1,r2,r3,a0,a1,sb")
#define INT_EXIT_PLAIN  __asm__("popm\tr0,r1,r2,r3,a0,a1,sb,fb\n\t" \
				"reit")
#define INT_EXIT_STACK  __asm__("popm\tr0,r1,r2,r3,a0,a1,sb\n\t"    \
				"mov.w\tr0,-2[fb]\n\t"		    \
				"stc\tfb,r0\n\t"		    \
				"ldc\tr0,sp\n\t"		    \
				"mov.w\t-2[fb],r0\n\t"		    \
				"popc\tfb\n\t"			    \
				"reit")

void int_key();

#endif /* _INTHANDLERS_H */
