/* main.c -- Main loop; every command is executed from here
 * Copyright (C) 2008  theDark
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "serial.h"
#include "display.h"
#include "generic.h"
#include "commands.h"
#include "sfr_r813.h"
#define BUF0 64
#define BUF1 8
#define BUF2 44

int main() {
	char buf0[BUF0];
	char buf1[BUF1];
	char buf2[BUF1];
	char buf3[BUF2];

//	initblink(); // just show something at startup

	inituart0();
//	initlcd(); // comment out if you want to use the display
	
	for(;;) {
		readrxd0(buf0, BUF0);
		splitstr(buf0, buf1, BUF1, 1);
		
		if(eq(buf1, "led")) {
			splitstr(buf0, buf1, BUF1, 2);
			splitstr(buf0, buf2, BUF1, 3);
			c_led(buf1, buf2);
		}
		else if(eq(buf1, "lcd")) {
			splitstr(buf0, buf1, BUF1, 2);
			splitstr(buf0, buf3, BUF2, 3);
			splitstr(buf0, buf2, BUF1, 4);
			c_lcd(buf1, buf3, buf2);
		}
		else if(eq(buf1, "analog")) {
			c_analog();
		}
		else if(eq(buf1, "stepper")) {
			splitstr(buf0, buf1, BUF1, 2);
			splitstr(buf0, buf2, BUF1, 3);
			splitstr(buf0, buf3, BUF1, 4);
			c_stepper(buf1, buf2, buf3);
		}
		else if(eq(buf1, "key")) {
			splitstr(buf0, buf1, BUF1, 2);
			c_key(buf1);
		}


		else if(eq(buf1, "help")) {
			splitstr(buf0, buf1, BUF1, 2);
			c_help(buf1);
		}
		else if(*buf1 == '\0'); // ignore a simple newline
		else {
			writetxd0("Unknown command: \"");
			writetxd0(buf1);
			writetxd0("\"\n");
		}
	}

	return 0; // actually this should never happen
}

