/* serial.c -- Basic I/O functions to deal with uart0
 * Copyright (C) 2008  theDark
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "sfr_r813.h"
#include "serial.h"


void inituart0() {
	pd1_4 = 1;	// txd0 direction = output
	pd1_5 = 0;	// rxd0 direction = input
	p1_4 = 1;	// txd0 = high
	u0mr = 0x05;	// 8 bit uart transfer mode
	u0brg = 129;	// 9600 baund
	te_u0c1 = 1;	// enable transmission
	re_u0c1 = 1;	// enable reception
}

void sendtxd0(unsigned char c) {
	while(!ti_u0c1) 	// wait for empty buffer
		wdtr = 0x00;
	u0tbl = c;		// write data to buffer
	te_u0c1 = 1;		// enable transmission
}

unsigned char receiverxd0() {
	unsigned char c;
	unsigned char d;
	
	while(!ri_u0c1)		// wait for full buffer
		wdtr = 0x00;
	ri_u0c1 = 0;		// disable reception
	c = u0rbl;		// read data from buffer
	d = u0rbh;		// read error from buffer and discard it
	re_u0c1 = 1;		// enable reception
	
	return c;
}


void writetxd0(const char *buffer) {
	int i;

	for(i = 0; buffer[i] != '\0'; i++)
		sendtxd0(buffer[i]);
}

void readrxd0(char *buffer, unsigned int len) {
	int i;
	char c;

	for(i = 0; i < len; i++) {
		c = receiverxd0();
		if(c == '\n' || c == '\0')
			break;
		buffer[i] = c;
	}

	if(i > len-2)
		i = len-2;

	buffer[i++] = '\n';
	buffer[i] = '\0';
}

