; start.s -- Initialize the main clock and jump to main()
; Copyright (C) 2008  theDark
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see <http://www.gnu.org/licenses/>.


.section ".resetvec", "a"
	.long	_start		; entry point after reset


.section ".rodata", "a"		; relocatable vector tables
inttable:
	.long	int_d		; BRK instruction
	.skip 	48		; (reserved space)
	.long	_int_key	; key input interrupt
	.long	int_d		; A/D conversion
	.skip 	4		; (reserved space)
	.long	int_d		; Compare 1
	.long	int_d		; UART0 transmit
	.long	int_d		; UART0 receive
	.long	int_d		; UART1 transmit
	.long	int_d		; UART1 receive
	.long	int_d		; INT2
	.long	int_d		; Timer X
	.long	int_d		; Timer Y
	.long	int_d		; Timer Z
	.long	int_d		; INT1
	.long	int_d		; INT3
	.long	int_d		; Timer C
	.long	int_d		; Compare 0
	.long	int_d		; INT0
	.skip	8		; (reserved space)
	.long	int_d		; int 32
	.long	int_d		; int 33
	.long	int_d		; int 34
	.long	int_d		; int 35
	.long	int_d		; int 36
	.long	int_d		; int 37
	.long	int_d		; int 38
	.long	int_d		; int 39
	.long	int_d		; int 40
	.long	int_d		; int 41
	.long	int_d		; int 42
	.long	int_d		; int 43
	.long	int_d		; int 44
	.long	int_d		; int 45
	.long	int_d		; int 46
	.long	int_d		; int 47
	.long	int_d		; int 48
	.long	int_d		; int 49
	.long	int_d		; int 50
	.long	int_d		; int 51
	.long	int_d		; int 52
	.long	int_d		; int 53
	.long	int_d		; int 54
	.long	int_d		; int 55
	.long	int_d		; int 56
	.long	int_d		; int 57
	.long	int_d		; int 58
	.long	int_d		; int 59
	.long	int_d		; int 60
	.long	int_d		; int 61
	.long	int_d		; int 62
	.long	int_d		; int 63


.text
	.global _start		; entry point for the linker

_start:
	ldc	#0x800, sp	; set stack pointer to the end of mem
	mov.b	#0x01, 0x0a	; disable protection for clock registers
	mov.b	#0x08, 0x06	; xin/xout: on, cm16/cm17: valid
	mov.b	#0x28, 0x07	; xin/xout pin, no division mode (high speed)
	nop
	nop
	nop
	nop			; do nothing, wait for stable main clock
	nop
	nop
	nop
	nop
	mov.b	#0x00, 0x0c	; select main clock (external)
	mov.b	#0x00, 0x0a	; re-enable protection

	ldc	#0x00,intbh	; load location of relocatable vector tables
	ldc	#inttable,intbl
	fset	I		; set the I Flag (switch Interrupts on)

	jsr.w	_main		; jump to main()

loop:
	jmp.w	loop		; if main() returns: infinite loop


int_d:				; this is a dummy interrupt handler
	reit			; just return

