/* stepper.c -- Basic functions to control stepper motors
 * Copyright (C) 2008  theDark
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "stepper.h"
#include "generic.h"


void stepper_fwd(volatile char *portd,
		 volatile char *port, unsigned int cycles) {
	int i;
	
	// take the lower 4 bits
	*portd |= 0x0f;
	
	for(i = 0; i < cycles; i++) {
		*port &= 0xf9;	// pi_1 and pi_2 off
		*port |= 0x09;	// pi_0 and pi_3 on
		wait(10000);
		*port &= 0xf3;	// pi_2 and pi_3 off
		*port |= 0x03;	// pi_0 and pi_1 on
		wait(10000);
		*port &= 0xf6;	// pi_0 and pi_3 off
		*port |= 0x06;	// pi_1 and pi_2 on
		wait(10000);
		*port &= 0xfc;	// pi_0 and pi_1 off
		*port |= 0x0c;	// pi_2 and pi_3 on
		wait(10000);
	}

	*port &= 0xf0;	// all ports off
}


void stepper_rew(volatile char *portd,
		 volatile char *port, unsigned int cycles) {
	int i;
	
	// take the lower 4 bits
	*portd |= 0x0f;
	
	for(i = 0; i < cycles; i++) {
		*port &= 0xfc;	// pi_0 and pi_1 off
		*port |= 0x0c;	// pi_2 and pi_3 on
		wait(10000);
		*port &= 0xf6;	// pi_0 and pi_3 off
		*port |= 0x06;	// pi_1 and pi_2 on
		wait(10000);
		*port &= 0xf3;	// pi_2 and pi_3 off
		*port |= 0x03;	// pi_0 and pi_1 on
		wait(10000);
		*port &= 0xf9;	// pi_1 and pi_2 off
		*port |= 0x09;	// pi_0 and pi_3 on
		wait(10000);
	}

	*port &= 0xf0;	// all ports off
}

